//
//  MCLinkListView.h
//  MCApplication
//
//  Created by Ali Lalani on 9/1/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCArrayController.h"
#import "MCStackBackgroundColorView.h"
#import "MCRolloverMenuButton.h"
#import "MCMenuManagerSupportProtocol.h"

@class MCLinkListArrayController,MCWebViewController,MCWebKitTemplateView,MCToggleButtonBar,MCTableView;
@class MCAttributedStringDisplayView,MCLinkingContext,MCLinkListTableHeader,MCGenericPlaceholderView;

@interface MCLinkListView : MCStackBackgroundColorView <MCMenuManagerSupport>{
	// Outlets
	IBOutlet MCTableView                   *tableView;
	IBOutlet MCLinkListArrayController     *arrayController;
	IBOutlet MCAttributedStringDisplayView *attrDisplayView;
	IBOutlet MCWebKitTemplateView          *webKitTemplateView;
	IBOutlet MCLinkListTableHeader         *buttonBarHeader;

	// Objects
	MCGenericPlaceholderView *placeholderView;

	MCToggleButtonBar  *toggleButtonBar;
	MCLinkingContext   *linkingContext;
	NSString           *identifier;
	NSMutableArray     *buttons;
	NSAttributedString *attributedDisplayString;
	NSDictionary       *displayStringAttributes;
	id                  parentController;

	// Bindings
	NSMutableDictionary *observerDictionary;
	NSArray             *resultsSelectedObjects;
	NSMutableArray        *linkedObjects;

	// Primitives
	float stringMaxX;	

	BOOL suspendLinkedListResultsSelection;

	BOOL __needsRefresh;
}

- (void)_configure;
- (void)tile;
- (void)resultsSelectionDidChange;
- (void)setupObservers;
- (NSArray *)selectedObjects;
- (void)togglePlaceholderVisible;

// Actions
- (IBAction)toggleButtonBarActed:(id)sender;
- (IBAction)showSelectedObjects:(id)sender;
- (IBAction)placeholderViewDidAct:(id)sender;

- (void)resetLinkedObjects;
- (void)updateWebView;
- (NSArray *)activeEntityClassnames;

- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (NSArray *)resultsSelectedObjects;
- (void)setResultsSelectedObjects:(NSArray *)aResultsSelectedObjects;

- (NSMutableArray *)linkedObjects;
- (void)setLinkedObjects:(NSMutableArray *)aLinkedObjects;

- (NSMutableArray *)buttons;
- (void)setButtons:(NSMutableArray *)aButtons;

- (void)setParentController:(id)anObj;
- (id)parentController;

- (MCArrayController *)arrayController;

- (BOOL)isTwoPaneMode;

- (MCToggleButtonBar *)toggleButtonBar;


- (BOOL)suspendLinkedListResultsSelection;
- (void)setSuspendLinkedListResultsSelection:(BOOL)flag;

- (MCLinkingContext *)linkingContext;
- (void)setLinkingContext:(MCLinkingContext *)aLinkingContext;

- (MCToggleButtonBar *)toggleButtonBar;
- (void)setToggleButtonBar:(MCToggleButtonBar *)aToggleButtonBar;

- (MCGenericPlaceholderView *)placeholderView;
- (void)setPlaceholderView:(MCGenericPlaceholderView *)aPlaceholderView;
@end
